# 📦 How to Package & Install the Extension

If your system requires you to **"Install"** the extension (instead of just uploading files), follow these steps to create a proper installation package.

## 1. Create the Extension Package (ZIP)

You need to zip the `MarketingBot` folder.

### Option A: Using Terminal (Mac/Linux)
Run this command in your project root:

```bash
cd "app/Extensions"
zip -r marketing-bot.zip MarketingBot
```

### Option B: Using Finder (Mac)
1. Go to `app/Extensions/`
2. Right-click on `MarketingBot` folder
3. Click **"Compress MarketingBot"**
4. Rename the file to `marketing-bot.zip`

---

## 2. Install via Admin Panel

1. Log in to your **Admin Panel**
2. Go to **Extensions** (or Modules)
3. Click **"Install Extension"** (or "Upload")
4. Select the `marketing-bot.zip` file you just created
5. Click **Install**

---

## 3. What This Does

The installer will read the `extension.json` file inside the package and:
1. ✅ Register the extension in the database
2. ✅ Run the migrations automatically
3. ✅ Clear the cache
4. ✅ Enable the routes

---

## ⚠️ Important Note

If you are **updating** an existing extension:
1. You might need to **Uninstall** the old version first (be careful, this might delete data!)
2. OR, just upload the files manually as described in the [CPANEL_INSTALLATION_GUIDE.md](file:///Users/hicham/Downloads/Gemine%20Test/CPANEL_INSTALLATION_GUIDE.md) and run `php artisan migrate`.

**Manual upload is safer** for updates because it preserves your existing data!
